#include <bits/stdc++.h>

struct Frilenser {
	int plata;
	double porez;

	bool operator<(const Frilenser& drugi) {
		return porez < drugi.porez;
	}
	bool operator>(const Frilenser& drugi) {
		return porez > drugi.porez;
	}
};

auto main() -> int {
	std::ios_base::sync_with_stdio(false);

	int n;
	std::cin >> n;

	std::vector<Frilenser> frilenseri(n);

	for (auto& f : frilenseri)
		std::cin >> f.plata >> f.porez;

	std::sort(begin(frilenseri), end(frilenseri));

	auto trenutni = begin(frilenseri);
	double max_zarada = 0.0;

	while (trenutni != end(frilenseri)) {
		const auto zarada = std::accumulate(trenutni, end(frilenseri), 0.0d, [](auto& sum, const auto& f) {
				return sum + f.plata;
		}) * (trenutni->porez / 100.0d);

		max_zarada = std::max(max_zarada, zarada);

		auto sledeci = trenutni + 1;
		while (sledeci != end(frilenseri) && sledeci->porez == trenutni->porez)
			++sledeci;
		trenutni = sledeci;
	}

	std::cout << max_zarada << '\n';
}